<?php
include 'db.php';

// ADD OWNER PAYMENT
if (isset($_POST['add_owner_payment'])) {
    $budget_id = (int)$_POST['budget_id'];
    $project_id = (int)$_POST['project_id'];
    $amount = floatval($_POST['amount']);
    $payment_date = !empty($_POST['payment_date']) ? $_POST['payment_date'] : date('Y-m-d H:i:s');

    $stmt = $conn->prepare("INSERT INTO payments (project_id, amount, payment_date) VALUES (?, ?, ?)");
    $stmt->bind_param("ids", $project_id, $amount, $payment_date);
    $stmt->execute();
    $stmt->close();
}

// DELETE BUDGET (only if no payments exist)
if (isset($_GET['delete'])) {
    $delete_id = (int)$_GET['delete'];
    $check = $conn->prepare("SELECT COUNT(*) AS count FROM payments WHERE project_id IN (SELECT project_id FROM budgets WHERE id = ?)");
    $check->bind_param("i", $delete_id);
    $check->execute();
    $res = $check->get_result()->fetch_assoc();
    $check->close();

    if ($res['count'] == 0) {
        $conn->query("DELETE FROM budgets WHERE id = $delete_id");
        echo "<script>alert('Budget deleted successfully!');window.location='budgets.php';</script>";
    } else {
        echo "<script>alert('Cannot delete: Payments already exist for this project.');</script>";
    }
}

// FETCH BUDGETS
$sql = "SELECT b.id, b.project_id, p.name AS project_name, b.allocated,
            IFNULL((SELECT SUM(pay.amount) FROM payments pay WHERE pay.project_id = b.project_id), 0) AS owner_paid,
            IFNULL((SELECT SUM(ap.amount) FROM assignment_payments ap JOIN assignments a2 ON a2.id=ap.assignment_id WHERE a2.project_id = b.project_id), 0) AS used
        FROM budgets b
        LEFT JOIN projects p ON p.id = b.project_id
        ORDER BY b.id DESC";
$budgets = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Budgets Management</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <style>
    .collapse-card {
      display: none;
      background: #fff;
      border: 1px solid #dee2e6;
      border-top: none;
      padding: 15px;
      margin-top: -1px;
      border-radius: 0 0 10px 10px;
    }
  </style>
</head>
<body class="bg-light">

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Project Budgets</h4>
    <a href="add_budget.php" class="btn btn-primary">+ Add Budget</a>
  </div>

  <div class="card">
    <div class="card-body table-responsive">
      <table id="budgetsTable" class="table table-bordered table-striped align-middle">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Project</th>
            <th>Allocated (Tshs.)</th>
            <th>Owner Paid (Tshs.)</th>
            <th>Used (Tshs.)</th>
            <th>Remaining Owner Paid (Tshs.)</th>
            <th>Remaining Budget (Tshs.)</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
        <?php
        $sn = 1;
        while ($b = $budgets->fetch_assoc()):
          $allocated = floatval($b['allocated']);
          $owner_paid = floatval($b['owner_paid']);
          $used = floatval($b['used']);
          $remaining_owner = max(0, $owner_paid - $used);
          $remaining_budget = $allocated - $used;
        ?>
          <tr data-collapse-id="<?= (int)$b['id'] ?>">
            <td><?= $sn++ ?></td>
            <td><?= htmlspecialchars($b['project_name']) ?> <small class="text-muted">(#<?= (int)$b['project_id'] ?>)</small></td>
            <td class="text-end"><?= number_format($allocated,2) ?></td>
            <td class="text-end"><?= number_format($owner_paid,2) ?></td>
            <td class="text-end"><?= number_format($used,2) ?></td>
            <td class="text-end"><?= number_format($remaining_owner,2) ?></td>
            <td class="text-end"><?= number_format($remaining_budget,2) ?></td>
            <td class="text-center">
              <div class="btn-group btn-group-sm" role="group">
                <button class="btn btn-success toggle-payments" data-id="<?= (int)$b['id'] ?>">Owner Payments</button>
                <a href="?delete=<?= (int)$b['id'] ?>" class="btn btn-danger"
                   onclick="return confirm('Are you sure you want to delete this budget?')">Delete</a>
              </div>
            </td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php
  // Render hidden collapses
  mysqli_data_seek($budgets, 0);
  while ($b = $budgets->fetch_assoc()):
  ?>
    <div id="collapse-<?= (int)$b['id'] ?>" class="collapse-card">
      <h6 class="mb-3">Owner Payments for: <?= htmlspecialchars($b['project_name']) ?></h6>
      <form method="post" class="row g-2 align-items-center mb-3">
        <input type="hidden" name="budget_id" value="<?= (int)$b['id'] ?>">
        <input type="hidden" name="project_id" value="<?= (int)$b['project_id'] ?>">
        <div class="col-md-3">
          <input type="number" step="0.01" name="amount" class="form-control" placeholder="Amount" required>
        </div>
        <div class="col-md-3">
          <input type="datetime-local" name="payment_date" class="form-control">
        </div>
        <div class="col-md-3">
          <button type="submit" name="add_owner_payment" class="btn btn-primary">Add Owner Payment</button>
        </div>
      </form>

      <?php
      $stmt = $conn->prepare("SELECT amount, payment_date FROM payments WHERE project_id = ? ORDER BY payment_date DESC");
      $stmt->bind_param("i", $b['project_id']);
      $stmt->execute();
      $res = $stmt->get_result();
      if ($res && $res->num_rows > 0):
      ?>
        <table class="table table-sm table-bordered">
          <thead class="table-light">
            <tr><th>Date</th><th class="text-end">Amount (Tshs.)</th></tr>
          </thead>
          <tbody>
            <?php while ($p = $res->fetch_assoc()): ?>
              <tr>
                <td><?= htmlspecialchars($p['payment_date']) ?></td>
                <td class="text-end"><?= number_format($p['amount'], 2) ?></td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      <?php else: ?>
        <p><em>No payments yet.</em></p>
      <?php endif; $stmt->close(); ?>
    </div>
  <?php endwhile; ?>

</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    $('#budgetsTable').DataTable({
        pageLength: 5,
        lengthChange: false,
        order: [],
        columnDefs: [{ orderable: false, targets: [7] }]
    });

    // Toggle collapse
    $('.toggle-payments').click(function() {
        let id = $(this).data('id');
        $('.collapse-card').not('#collapse-' + id).slideUp();
        $('#collapse-' + id).slideToggle();
    });
});
</script>
</body>
</html>
